#include "lib\curses.h"
#include "gui.h"
#include <time.h>
#include <stdlib.h>

extern byte local_x, local_y, local_temp1;
extern byte visible_board[8][8];
extern byte visible_board_white_pieces;
extern byte visible_board_black_pieces;
extern byte move_x;
extern byte move_y;
extern byte current_color;
extern byte game_turn;

extern byte current_color;
extern bool black_computer_controlled;
extern bool white_computer_controlled;
extern byte tree_depth;


byte my_random(byte range)
{
	if (range==0)
		return 0;
	else
		return rand()%range;
}

void show_board()
{
#if !GENETIC_MODE
	for (local_y=0;local_y<8;++local_y)
	{
		for (local_x=0;local_x<8;++local_x)
		{
			switch(visible_board[local_y][local_x])
			{
			case WHITE:
				local_temp1='0';
				break;
			case BLACK:
				local_temp1='1';
				break;
			case EMPTY:
				local_temp1='.';
				break;
			case POSSIBLE_MOVE:
				local_temp1='+';
				break;
			}
			mvaddch(local_y,local_x,local_temp1);
		}
	}	
	refresh();
#endif

}

void show_score()
{
#if !GENETIC_MODE
	mvprintw(10,0,"WHITE PIECES: %d  ",visible_board_white_pieces);
	mvprintw(11,0,"BLACK PIECES: %d  ",visible_board_black_pieces);

	if (current_color==WHITE)
		mvaddstr(13,0,"WHITE TURN");
	else
		mvaddstr(13,0,"BLACK TURN");

	mvprintw(13,11,"%d  ",game_turn);
	refresh();
#endif
}

void setup_colors()
{
	short i, j;

	for (i = 0; i < 8; i++)
		for (j = 0; j < 8; j++)
			if ((i > 0) || (j > 0))
				init_pair(i * 8 + j, j, i);

	init_pair(63, COLOR_BLACK, COLOR_BLACK);
}


void system_init()
{
	initscr();
	raw();
	if (has_colors())
		start_color();
	noecho();	
	keypad(stdscr, TRUE);
	curs_set(2);
	resize_term(30,40);

	mouse_on(ALL_MOUSE_EVENTS);
	nodelay(stdscr,TRUE);
	cbreak();
	setup_colors();
	srand((unsigned int) time(NULL));
}

byte cursor_x, cursor_y;

bool get_player_action()
{
	int key;
	for(;;)
	{
		key=getch();
		request_mouse_pos();
		if (MOUSE_X_POS!=cursor_x || MOUSE_Y_POS!=cursor_y)
		{
			cursor_x=MOUSE_X_POS;
			cursor_y=MOUSE_Y_POS;

			curs_set(0);
			move(cursor_y,cursor_x);
			refresh();
			curs_set(2);
		}
		if (cursor_x<8 && cursor_y<8 && key==KEY_MOUSE)
		{
			if (visible_board[cursor_y][cursor_x]==POSSIBLE_MOVE)
			{
				move_x=cursor_x;
				move_y=cursor_y;
				return true;
			}
		}
	}
	return false;
}

void winner(byte who)
{
	int key;
	char *w;
	switch(who)
	{
		case WHITE:
			w="WHITE";
			break;
		case BLACK:
			w="BLACK";
			break;
		default:
			w="NOBODY";
			break;
	}
	mvprintw(15,0,"%s wins!",w);
	for(;;)
	{
		key=getch();
		if (key==KEY_MOUSE)
			break;
	}
}

void mark_last_move()
{
#if SHOW_DEBUG
	if (move_x!=0xFF)
		mvaddch(move_y,move_x,'*');
	refresh();
#endif
}

void configure_game()
{
#if GENETIC_MODE
	black_computer_controlled=true;
#else
	black_computer_controlled=false;
#endif
	white_computer_controlled=true;
	current_color=BLACK;
	tree_depth=3; // 2,4,6
}
